<?php defined('SYSPATH') OR die('No direct access allowed.');

$config = [
    /* storage_1 */
    'loft11321' => [
        'name' => 'storage_1',
        'ip' => [
            'srw' => '10.0.0.4',
            'admin' => '10.0.0.2',
            'import' => '10.0.0.1',
            'gearman' => '10.0.0.3', // local gearman ip
        ],
        'insert' => [
            'clients' => [
                'name' => 'clients',
            ],
        ],
        'database' => 'default',
        'sphinx' => 'sphinx',
        'count_lastlogins' => 100,
    ],
    /* storage_2 */
    'CZ11' => [
        'name' => 'storage_2',
        'ip' => [
            'admin' => '10.0.0.2',
            'import' => '10.0.0.1',
            'gearman' => '10.0.0.3', // local gearman ip
        ],
        'insert' => [
            'clients' => [
                'name' => 'clients',
            ],
        ],
        'database' => 'default',
        'sphinx' => 'sphinx',
        'count_lastlogins' => 100,
    ],

    /* developer_1 */
    'vb' => [
        'name' => 'developer_1',
        'local_info' => [ // todo old?
            'ip' => '127.0.0.1',
            'tor' => '',
        ],
        'ip' => [
            'srw' => '127.0.0.1',
            'admin' => '127.0.0.1',
            'import' => '127.0.0.1',
            'gearman' => '127.0.0.1',
        ],
        'insert' => [
            'logpost' => [ // todo old?
                'name' => 'logpost',
                'db_config' => 'sphinx',
            ],
            'clients' => [
                'name' => 'clients',
                'db_config' => 'sphinx', // todo old?
            ],
        ],
        'database' => 'default',
        'sphinx' => 'sphinx',
        'count_lastlogins' => 100,
    ],

    /* developer_2 */
    'work-work' => [
        'name' => 'developer_2',
        'local_info' => [
            'ip' => '127.0.0.1',
            'tor' => '',
        ],
        'ip' => [
            'srw' => '127.0.0.1',
            'admin' => '127.0.0.1',
            'import' => '127.0.0.1',
            'gearman' => '127.0.0.1',
        ],
        'insert' => [
            'logpost' => [
                'name' => 'logpost',
                'db_config' => 'sphinx',
            ],
            'clients' => [
                'name' => 'clients',
                'db_config' => 'sphinx',
            ],
        ],
        'database' => 'default',
        'sphinx' => 'sphinx',
        'count_lastlogins' => 100,
    ],
];

return Arr::get($config, gethostname());
